SELECT
    t.Symbol
    , t.FlIns AS MsnCode
    , t.ShtName AS Name
    , t.Ld AS LastDate
    , t.Lt AS LastTime
    , t.Pp AS [Previous]
    , t.Op AS [Open]
    , t.Dh AS [High]
    , t.Dl AS [Low]
    , t.Lp AS [Last]
    , t.Ch AS Change
    , t.Chp AS [Change,%]
    , t.V AS Volume
    , t.AvgV AS AvgVolume
    , t.Yh AS YearHigh
    , t.Yl AS YearLow
    , t.Yrr
    , t.Beta
    , t.Eps
    , t.FpEPS
    , t.Pe
    , t.YTD
    --, t.PrCh1Mo
    --, t.PrCh3Mo
    --, t.PrCh6Mo
    , t.DvRt AS DivRate
    , t.Dy AS DivYield
    --, t.Mc AS MarketCap
    --, t.Sec AS Sector
    --, t.Ind AS Industry
    --, t.LoadDate
FROM
    (
        SELECT
            Symbol
            , MAX(LoadDate) AS LoadDate
        FROM
            data
        GROUP BY
            Symbol
    ) s
    INNER JOIN data t ON t.Symbol = s.Symbol AND t.LoadDate = s.LoadDate
